#!/bin/bash
#SBATCH --job-name=ImageNet-1
#SBATCH -p q_intel_gpu_nvidia_h20_6 
#SBATCH -N 1
#SBATCH -G 8
#SBATCH -c 16
#SBATCH -w gpu018
#SBATCH -o /online1/ycsc_xfangam/xfangam/sunset/output/wasserstein_quantizer2/ImageNet-1k/error/result_P1.out
#SBATCH -e /online1/ycsc_xfangam/xfangam/sunset/output/wasserstein_quantizer2/ImageNet-1k/error/error_P1.out

source activate /home/export/base/ycsc_xfangam/xfangam/.conda/envs/share_VAR

torchrun --standalone --nproc_per_node=8 --nnodes=1 --node_rank=0  train_wasserstein_quantizer.py --epochs=20 --ae_lr=5e-4 --std=0.05 --global_batch_size=256 --codebook_size=100000 --latent_dim=4 --feature_dim=256 --alpha=0.2 --beta=0.2 --gamma=0.3 --lambd=1.0 --rate_d=0.3
torchrun --standalone --nproc_per_node=8 --nnodes=1 --node_rank=0  train_wasserstein_quantizer.py --epochs=20 --ae_lr=5e-4 --std=0.05 --global_batch_size=256 --codebook_size=50000  --latent_dim=4 --feature_dim=256 --alpha=0.2 --beta=0.2 --gamma=0.3 --lambd=1.0 --rate_d=0.3
torchrun --standalone --nproc_per_node=8 --nnodes=1 --node_rank=0  train_wasserstein_quantizer.py --epochs=20 --ae_lr=5e-4 --std=0.05 --global_batch_size=256 --codebook_size=16384  --latent_dim=4 --feature_dim=256 --alpha=0.2 --beta=0.2 --gamma=0.3 --lambd=1.0 --rate_d=0.3